/**
 * @fileoverview favList page control
 * @author sunnyjiang
 * @version 1.0
 */

/**
 * @namespace fav list
 */
var curID;
var rootID;
var isDrag = 0;
var favList = {};

favList.isLogon = false;
favList.isSyncError = false;
favList.isSyncLoading = false;
favList.isRetry = false;
favList.isUpload = false;
favList.maxHeight = 550;
favList.minHeight = 250;
favList.isChange = false;

// 数据上报相关项
var STATIS_FAV_TOOLBAR_ADD						= 910202;		///< “添加收藏”的点击次数				（10202）
var STATIS_FAV_TOOLBAR_MANAGE						= 910203;		///< “收藏管理”的点击次数				（10203）
var STATIS_FAV_TOOLBAR_CONTENT					= 910204;		///< 收藏内容区域的点击次数			（10204）

favList.newFolderName = "新建文件夹";

favList.onShowAfterHide = function() {
	try
		{
			var windowId = qqbrowser.window.currentId();

			var json = qqbrowser.window.getRect(windowId);
			var windowRect = JSON.parse(json);
			var windowHeight = windowRect.bottom - windowRect.top;

			var favListHeight = windowHeight * 0.7 < 550 ? Math.floor(windowHeight * 0.7) : 550; // 最小高度和皮肤窗口70%比较
			
	
			// 这里的计算有问题
			$('#favListALL').height(favListHeight - ($('body').outerHeight() - $('#favListALL').height())); // 改变内容高度

			qqbrowser.popup.show(qqbrowser.window.currentId(),$('#fav-list-layer').outerWidth(), favListHeight);
		}
		catch (e)
		{
		}
};

favList.exportRes = function(){
	favList.showDownSuccess();
};

var cube = function(selector)
{
	/*
	// ID selector
	if(selector.substring(0, 1) === '#') {
		return document.getElementById(selector.substr(1));
	}
	
	return document.querySelector(selector);
	*/
	
	return $(selector);
};

favList._bindEvents = function(){
	var addFav = cube('#addFav'),
		manage = cube('#manageFav'),
		openNewTab    = cube('#openNewTab'),    // [书签项]右键菜单的“在新标签页中打开”
		openNewWindow = cube('#openNewWindow'), // [书签项]右键菜单的“在新窗口中打开”
		copy          = cube('#copy'),          // [书签项]右键菜单的“复制网址URL”
		edit          = cube('#edit'),          // [书签项]右键菜单的“重命名”
		iDeleteFav    = cube('#iDeleteFav'),    // [书签项]右键菜单的“删除”

		openLinks     = cube('#openLinks'),     // [文件夹]右键菜单的“打开所有收藏”
		rename        = cube('#rename'),        // [文件夹]右键菜单的“重命名”
		deleteFav     = cube('#deleteFav'),     // [文件夹]右键菜单的“删除”
		addFolder     = cube('#addFolder'),     // [文件夹]右键菜单的“新建文件夹”
		sort          = cube('#sort'),          // [文件夹]右键菜单的“对选中目录按标题排序”
		
		getItemUrl = function()
		{
			var itemurl, f1 = document.getElementById(curID).childNodes;

			if(f1!=null) {
				var f2=f1[1].childNodes;
				itemurl=$(f2[0]).attr("href");
			}
			
			return itemurl;
		}
	
	document.onselectstart = document.ondragstart = function() {
		if(!event.target.id || event.target.tagName != 'INPUT') {
			return false;
		}
	};
	
	document.oncontextmenu = function() {
	};

	document.onclick=function(){
		if(document.activeElement != menu) 
			menu.style.display = "none";
		if(document.activeElement != foldermenu) 
			foldermenu.style.display = "none";
	};
	
	$(document).blur(function() {
		favList.editEnd();
	});

	// 左上角“添加收藏”功能的事件
	addFav.mousedown(function() {
		this.className = 'add-button pressed';
	}).mouseup(function() {
		this.className = 'add-button';
	}).click(function() {
		// 网络异常时的判断
		if ( !favList.checkSyncStatus() ) {
			return;
		}

		var favFolderId = $( 'div.title.selected' ).parent().attr( 'id' ),
			obj = qqbrowser.extension.dllLoader( 'bookmark.dll' );
		if ( !favFolderId ) {
			favFolderId = -1;
		}
		
		// 上报 导航栏收藏下拉面板的添加收藏点击次数
		browser.extension.builtin.statistics.increase(STATIS_FAV_TOOLBAR_ADD);
		obj.execDllFunc("onShowAddFavDlg", '', '', parseInt(favFolderId), qqbrowser.window.currentId(), 456, 381);
	});
	
	// 右上角“管理”功能的事件
	manage.mousedown(function() {
		this.className = 'manage-button pressed';
	}).mouseup(function() {
		this.className = 'manage-button';
	}).click(function() {
		browser.extension.builtin.statistics.increase(STATIS_FAV_TOOLBAR_MANAGE);
		qqbrowser.popup.close(qqbrowser.window.currentId());
		browser.tabs.create("qqbrowser:favorite", 0);
	});

	// “网络收藏下载成功”提示条右侧关闭按钮的事件
	$('#sync-close').mousedown(function() {
		$(this).addClass('pressed');
	}).click(function() {
		favList.hideSyncSuccess();
	}).mouseup(function() {
		$(this).removeClass('pressed');
	});
	
	$('#sync-error-retry').click(function() {
		favList.isRetry = true;
		qqbrowser.bookmark.retrySync();
	});
	
	openNewTab.click(function() {
		qqbrowser.bookmark.openUrlCurWindow(getItemUrl(), parseInt(curID));
	});

	openNewWindow.click(function() {
		qqbrowser.bookmark.openUrlNewWindow(getItemUrl(), parseInt(curID));
	});
	
	copy.click(function() {
		qqbrowser.bookmark.copyUrl(getItemUrl());
	});
	
	edit.click(function() {
		// 网络异常时的判断
		if(!favList.checkSyncStatus()) {
			return;
		} 
		
		favList.editLinkName(curID);
	});
	
	iDeleteFav.click(function() {
		// 网络异常时的判断
		if(!favList.checkSyncStatus()) {
			return;
		}
		
		var currentFav = $('#' + curID),
			name = $('div.title > div',currentFav).text(),
			currentFavHr = $('#' + curID).prev(),
			currentFav = $('#' + curID),
			currentFavParent = currentFav.parents('li.fav-folder')[0],
			parentChilds = $(' > ul > li:not(.hr)', currentFavParent);
		
		favList.isChange = true;
		confirm.setTitle('确认删除');
		confirm.setContent("确认删除</br><div class='fav-name'>“"+name+"</div>"+"” ？");
		confirm.setConfirm(function() {
			try{
				currentFav.remove(); // remove from view
				
				if(currentFavHr.is('.hr')) { // 删除hr
					currentFavHr.remove(); // remove from view	
				}
				
				if(parentChilds.length == 0) {
					$(' > div.title', currentFavParent).removeClass('open').addClass('blank');
					$(' > ul', currentFavParent).hide();
				}
				
				qqbrowser.bookmark.remove(parseInt(curID));			
			} catch(e) {
				debug('idelete' + e.message);
			}
			//favList.setTabindex();
		});
		confirm.show();
	});
	
	openLinks.click(function() {
		if ($(this).attr('class') !== 'disabled'){	
			qqbrowser.bookmark.openFolderCurWindow(parseInt(curID));
		}
	});
	
	rename.click(function() {
		// 网络异常时的判断
		if(!favList.checkSyncStatus()) {
			return;
		}
		
		// 不允许重命名根节点
		if(parseInt(curID)==parseInt(rootID)){
			return;
		}
		
		favList.editFolderName(curID);
	});
	
	deleteFav.click(function() {
		// 网络异常时的判断
		if(!favList.checkSyncStatus()) {
			return;
		} 
		
		if(parseInt(curID)==parseInt(rootID)){
			return;
		}
		
		var currentFav = $('#' + curID),
			name = $('span:first',currentFav).text(),
			currentFavHr = $('#' + curID).prev(),
			currentFav = $('#' + curID);
		
		favList.isChange = true;
		confirm.setTitle('确认删除');
		confirm.setContent("确认删除</br><div class='fav-name'>“"+name+"</div>"+"” ？");
		confirm.setConfirm(function() {
			try{
				currentFav.remove(); // remove from view
				
				if(currentFavHr.is('.hr')) { // 删除hr
					currentFavHr.remove(); // remove from view	
				}			
				
				qqbrowser.bookmark.removeTree(parseInt(curID));
			} catch(e) {
				debug('deleteFav' + e.message);
			}
		});
		confirm.show();
	});
	
	addFolder.click(function() {
		favList.isChange = true;
		if(!favList.checkSyncStatus()) {
			return;
		}
		$("#2 > ul > li.fav-folder > div.title");
		var searchString = ["#", curID, " > ul > li.fav-folder > div"].join(""),
			titleElements = $(searchString),
			count = 1,
			newFolderName = "新建文件夹",
			url = '';
			
		if(titleElements[0]===undefined){
		    title = "新建文件夹";
		}
		
		for(i=titleElements.length-1;i>-1;i--){
			if(titleElements[i].innerText === newFolderName){
			   ++count;
		       newFolderName = "新建文件夹("+count+")";
			   title = newFolderName ;
			}else{
			    title = newFolderName ;
			}
		}
		
		qqbrowser.bookmark.create(parseInt(curID), 0, title, url, favList.flush);
	});
	
	sort.click(function() {
		if($(this).hasClass('disabled')) { // 灰显时不可用
			return;
		}
		
		// 网络异常时的判断
		favList.isChange = true;
		if(!favList.checkSyncStatus()) {
			return;
		} 

		try {
			qqbrowser.bookmark.sort(parseInt(curID),"title", favList.sort);			
		} catch (e) {
		}
	});
	
	// Tab选中后，按回车，toggle展开状态
	$('li.fav-folder').live('keyup', function(event) {
		if(event.keyCode === 13) {
			favList.openFolder(this.getAttribute('id'));
		}
	});
	
	// 太多地方操作目录树了，添加不过来，考虑优化成自定义事件
	// tabIndex非常复杂，不能随便加这个功能，引起更多BUG
	// setInterval(function() {
	// 	favList.setTabindex();
	//}, 10);
};

favList.init = function() {
	// 判断帐号是否登录
	try {
		qqbrowser.account.getCurrent(function(data) {
			var userInfo = eval('(' + data + ')')[0];
			if(userInfo.nUin) {
				$('#favListHeaderTitle').hide();
				$('#login-button').hide();				
				$('#logonTitle').show();
				$('#username').text(unescape(userInfo.strNickName));

				favList.isLogon = true;
			}
		});
	} catch (e) {
	}
	
	// 登录后设置收藏Title
	try {
		qqbrowser.account.getCurrent(favList.setFavTitle);
		qqbrowser.account.onLogin.addListener(favList.setLogIn); 
		qqbrowser.account.onLogout.addListener(favList.setLogOut);
	} catch(e) {
	}
	
	try {
		qqbrowser.bookmark.getTree(favList.buildList); // call browser api
	} catch(e) {
		var favData = '["%5B%7B%22children%22:%5B%7B%22children%22:%5B%7B%22children%22:%5B%7B%22children%22:%5B%7B%22children%22:%5B%5D,%22dateAdded%22:2e+15,%22dateGroupModified%22:2e+15,%22id%22:%2250%22,%22index%22:0,%22parentId%22:%2249%22,%22title%22:%2255%22,%22type%22:%22folder%22%7D%5D,%22dateAdded%22:2e+15,%22dateGroupModified%22:2e+15,%22id%22:%2249%22,%22index%22:0,%22parentId%22:%222%22,%22title%22:%2233%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%5D,%22dateAdded%22:2e+15,%22dateGroupModified%22:2e+15,%22id%22:%2248%22,%22index%22:1,%22parentId%22:%222%22,%22title%22:%2211%22,%22type%22:%22folder%22%7D,%7B%22dateAdded%22:3e+15,%22id%22:%2247%22,%22index%22:2,%22parentId%22:%222%22,%22title%22:%22%5Cu5FEB%5Cu901F%5Cu94FE%5Cu63A5%22,%22type%22:%22url%22,%22url%22:%22qb:home%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2246%22,%22index%22:3,%22parentId%22:%222%22,%22title%22:%22%5Cu5FEB%5Cu901F%5Cu94FE%5Cu63A5%22,%22type%22:%22url%22,%22url%22:%22qb:home%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%223%22,%22index%22:4,%22parentId%22:%222%22,%22title%22:%22Mozilla:%20Alphabetical%20List%22,%22type%22:%22url%22,%22url%22:%22http://doxygen.db48x.net/mozilla/html/classes.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%224%22,%22index%22:5,%22parentId%22:%222%22,%22title%22:%22XPCOM%20API%20Reference%20-%20MDC%22,%22type%22:%22url%22,%22url%22:%22https://developer.mozilla.org/en/XPCOM_API_Reference%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22dateGroupModified%22:3e+15,%22id%22:%222%22,%22index%22:0,%22parentId%22:%221%22,%22title%22:%22FF%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%226%22,%22index%22:0,%22parentId%22:%225%22,%22title%22:%22%5Cu5728%5Cu6D4F%5Cu89C8%5Cu5668%5Cu53F3%5Cu952E%5Cu6DFB%5Cu52A0%5Cu81EA%5Cu5B9A%5Cu4E49%5Cu83DC%5Cu5355%22,%22type%22:%22url%22,%22url%22:%22http://www.playes.net/Blog/436.asp%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%227%22,%22index%22:1,%22parentId%22:%225%22,%22title%22:%22%5Cu5982%5Cu4F55%5Cu5BF9webbrowser%5Cu548CIE%5Cu7F16%5Cu7A0B%5CuFF08%5Cu4E00%5CuFF09%22,%22type%22:%22url%22,%22url%22:%22http://blog.csdn.net/shanhe/archive/2005/06/18/397373.aspx%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%228%22,%22index%22:2,%22parentId%22:%225%22,%22title%22:%22CodeProject:%20Programming%20Toolbar%20Chevrons.%20Free%20source%20code%20and%20programming%20help%22,%22type%22:%22url%22,%22url%22:%22http://www.codeproject.com/KB/toolbars/chevrons.aspx%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%229%22,%22index%22:3,%22parentId%22:%225%22,%22title%22:%22CSDN%5Cu6280%5Cu672F%5Cu4E2D%5Cu5FC3%20%5Cu7F16%5Cu5199%5Cu53EF%5Cu590D%5Cu7528%5Cu6027%5Cu66F4%5Cu597D%5Cu7684C++%5Cu4EE3%5Cu7801%5Cu2014%5Cu2014Band%5Cu5BF9%5Cu8C61%5Cu548CCOMToys(%5Cu516B)%22,%22type%22:%22url%22,%22url%22:%22http://dev.csdn.net/article/83373.shtm%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2210%22,%22index%22:4,%22parentId%22:%225%22,%22title%22:%22ToolbarStudio%20IE%20Toolbar%20builder%22,%22type%22:%22url%22,%22url%22:%22http://www.besttoolbars.net/quick_tour.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2211%22,%22index%22:5,%22parentId%22:%225%22,%22title%22:%22Desktop%20Applications%7C%5Cu684C%5Cu9762%5Cu80A1%5Cu7968%5Cu8F6F%5Cu4EF6%7C%5Cu57FA%5Cu91D1%5Cu52A9%5Cu624B%7C%5Cu6C7D%5Cu8F66%5Cu6CB9%5Cu8017%5Cu8BA1%5Cu7B97%5Cu5668%7CSTK%7C%5Cu80A1%5Cu5E02%5Cu884C%5Cu60C5%22,%22type%22:%22url%22,%22url%22:%22http://www.dtapp.cn/%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2212%22,%22index%22:6,%22parentId%22:%225%22,%22title%22:%22%5Cu516C%5Cu53F8%5Cu8BC4%5Cu7EA7%22,%22type%22:%22url%22,%22url%22:%22http://stock.eastmoney.com/channel/1067.html%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%225%22,%22index%22:1,%22parentId%22:%221%22,%22title%22:%22IE%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22children%22:%5B%7B%22children%22:%5B%5D,%22dateAdded%22:2e+15,%22id%22:%2215%22,%22index%22:0,%22parentId%22:%2214%22,%22title%22:%22%5Cu4E09%5Cu7EA7%5Cu76EE%5Cu5F55%22,%22type%22:%22folder%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2214%22,%22index%22:0,%22parentId%22:%2213%22,%22title%22:%22level2%5Cu4E8C%5Cu7EA7%5Cu76EE%5Cu5F55%22,%22type%22:%22folder%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2213%22,%22index%22:2,%22parentId%22:%221%22,%22title%22:%22level1%5Cu4E00%5Cu7EA7%5Cu76EE%5Cu5F55%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22children%22:%5B%5D,%22dateAdded%22:2e+15,%22id%22:%2219%22,%22index%22:0,%22parentId%22:%2218%22,%22title%22:%22TT%22,%22type%22:%22folder%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2220%22,%22index%22:1,%22parentId%22:%2218%22,%22title%22:%22%5Cu300AVisual%20C++%5Cu7A0B%5Cu5E8F%5Cu8BBE%5Cu8BA1%5Cu81EA%5Cu5B66%5Cu624B%5Cu518C%5Cu300B%22,%22type%22:%22url%22,%22url%22:%22http://www.mrbccd.com/ebook/ebook.php%3Fid=44%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2221%22,%22index%22:2,%22parentId%22:%2218%22,%22title%22:%22A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20T%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20L%20%5Cu5B9E%5Cu73B0%5Cu5B9A%5Cu5236%5Cu7684%20IE%20%5Cu6D4F%5Cu89C8%5Cu5668%5Cu680F%5Cu3001%5Cu5DE5%5Cu5177%5Cu680F%5Cu548C%5Cu684C%5Cu9762%5Cu5DE5%5Cu5177%5Cu680F%20-%20VC++%20-%20%5Cu9006%5Cu98CE%5Cu8005%22,%22type%22:%22url%22,%22url%22:%22http://www.upwinder.com/www/04/249.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2222%22,%22index%22:3,%22parentId%22:%2218%22,%22title%22:%22ATL%20%5Cu5B9E%5Cu73B0%5Cu5B9A%5Cu5236%5Cu7684%20IE%20%5Cu6D4F%5Cu89C8%5Cu5668%5Cu680F%5Cu3001%5Cu5DE5%5Cu5177%5Cu680F%5Cu548C%5Cu684C%5Cu9762%5Cu5DE5%5Cu5177%5Cu680F%20-%20VC++%20-%20%5Cu9006%5Cu98CE%5Cu8005%22,%22type%22:%22url%22,%22url%22:%22http://www.upwinder.com/www/04/249.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2223%22,%22index%22:4,%22parentId%22:%2218%22,%22title%22:%22C++%5Cu5B57%5Cu7B26%5Cu4E32%5Cu5B8C%5Cu5168%5Cu6307%5Cu5357(2)%20-%20%5Cu5404%5Cu79CD%5Cu5B57%5Cu7B26%5Cu4E32%5Cu7C7B%5CuFF08%5Cu4E00%5CuFF09%20-%20mailao%20-%20%5Cu6B6A%5Cu9177%5Cu535A%5Cu5BA2%20Ycool%20Blog%22,%22type%22:%22url%22,%22url%22:%22http://mailao.ycool.com/post.1515533.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2224%22,%22index%22:5,%22parentId%22:%2218%22,%22title%22:%22com%5Cu7EC4%5Cu4EF6%5Cu8BBE%5Cu8BA1%5Cu4E0E%5Cu5E94%5Cu7528%22,%22type%22:%22url%22,%22url%22:%22http://www.vckbase.com/vckbase/columnist/yangfeng/%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2225%22,%22index%22:6,%22parentId%22:%2218%22,%22title%22:%22error%20c3755%20-%20Google%20%5Cu641C%5Cu7D22%22,%22type%22:%22url%22,%22url%22:%22http://www.google.com.hk/search%3Fhl=zh-CN%26source=hp%26q=error+c3755%26aq=f%26aqi=%26aql=%26oq=%26gs_rfai=%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2226%22,%22index%22:7,%22parentId%22:%2218%22,%22title%22:%22VC%5Cu77E5%5Cu8BC6%5Cu5E93%3E%3E%5Cu6587%5Cu6863%5Cu4E2D%5Cu5FC3-toolbar%22,%22type%22:%22url%22,%22url%22:%22http://www.vckbase.com/document/listdoc.asp%3Fsclsid=305%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2227%22,%22index%22:8,%22parentId%22:%2218%22,%22title%22:%22%5Cu65B0%5Cu6807%5Cu7B7E%5Cu9875%22,%22type%22:%22url%22,%22url%22:%22chrome-internal:%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2218%22,%22index%22:3,%22parentId%22:%221%22,%22title%22:%22VCKBASE%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%2229%22,%22index%22:0,%22parentId%22:%2228%22,%22title%22:%22C++%20FAQ%20LITE%22,%22type%22:%22url%22,%22url%22:%22http://www.sunistudio.com/cppfaq/index.html%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2230%22,%22index%22:1,%22parentId%22:%2228%22,%22title%22:%22Auto-Detect%20RSS%22,%22type%22:%22url%22,%22url%22:%22javascript:(%257BaddURL:function(aURL)%257Bvar%2520url=%2522http://feeds.ramisp.org/preview.php%3Futf=y%26src=%2522+encodeURIComponent(aURL);location.href=url;%257D,getFeedURL:function(e,aDocument)%257Bvar%2520j=e;var%2520c=aDocument.location;if(e.indexOf(%2522/%2522)!=0)%257Bvar%2520d=c.pathname.split(%2522/%2522);d%255Bd.length-1%255D=e;j=d.join(%2522/%2522)%257Dreturn%2520c.protocol+%2522//%2522+c.hostname+j;%257D,checkForFeeds:function()%257Bvar%2520f=false;var%2520m=document.getElementsByTagName(%2522link%2522);for(var%2520g=0,a;a=m%255Bg%255D;g++)%257Bvar%2520h=a.getAttribute(%2522type%2522);var%2520i=a.getAttribute(%2522rel%2522);if(h%26%26h.match(/%255B%255C+%255C/%255Dxml%2524/)%26%26i%26%26i==%2522alternate%2522)%257Bvar%2520b=a.getAttribute(%2522href%2522);if(b.indexOf(%2522http%2522)!=0)%257Bb=this.getFeedURL(b,document);%257Dthis.addURL(b);f=true;break%257D%257Dif(!f)alert(%2522Oops.%2520Can%27t%2520find%2520a%2520feed.%2522);%257D%257D).checkForFeeds();%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2231%22,%22index%22:2,%22parentId%22:%2228%22,%22title%22:%22%5Cu5982%5Cu4F55%5Cu4EE5%5Cu7F16%5Cu7A0B%5Cu65B9%5Cu5F0F%5Cu5C06%5Cu4E00%5Cu4E2A%20IMG%20%5Cu5143%5Cu7D20%5Cu590D%5Cu5236%5Cu5230%5Cu526A%5Cu8D34%5Cu677F%22,%22type%22:%22url%22,%22url%22:%22http://support.microsoft.com/kb/293125/%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2228%22,%22index%22:4,%22parentId%22:%221%22,%22title%22:%22%5Cu7F16%5Cu7A0B%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%2233%22,%22index%22:0,%22parentId%22:%2232%22,%22title%22:%22%5Cu7EFF%5Cu91CE%20%5Cu6237%5Cu5916%5Cu7F51%20%22,%22type%22:%22url%22,%22url%22:%22http://www.lvye.info/%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2234%22,%22index%22:1,%22parentId%22:%2232%22,%22title%22:%22%5Cu4E16%5Cu754C%5Cu77E5%5Cu540D%5Cu6444%5Cu5F71%5Cu5E08%5Cu4F5C%5Cu54C1%20-%20%5Cu9F99%5Cu817E%5Cu8FD0%5Cu52A8%20%5Bhttp://user.qzone.qq.com/767089121%5D%22,%22type%22:%22url%22,%22url%22:%22http://b.qzone.qq.com/cgi-bin/blognew/simpleqzone_blog_data%3Fhostuin=767089121%26r=0%26idm=qzs.qq.com%26bdm=b.qzone.qq.com%26mdm=m.qzone.qq.com%26blogid=1272295693%26numperpage=15%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2232%22,%22index%22:5,%22parentId%22:%221%22,%22title%22:%22%5Cu6D4B%5Cu8BD5%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%2236%22,%22index%22:0,%22parentId%22:%2235%22,%22title%22:%22guoweijohn_%5Cu65B0%5Cu6D6A%5Cu535A%5Cu5BA2%22,%22type%22:%22url%22,%22url%22:%22http://blog.sina.com.cn/guoweijohn%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:2e+15,%22id%22:%2237%22,%22index%22:1,%22parentId%22:%2235%22,%22title%22:%22%5Cu7F20%5Cu4E2D%5Cu8BF4%5Cu7985_%5Cu65B0%5Cu6D6A%5Cu535A%5Cu5BA2%22,%22type%22:%22url%22,%22url%22:%22http://blog.sina.com.cn/u/1215172700%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2235%22,%22index%22:6,%22parentId%22:%221%22,%22title%22:%22%5Cu80A1%5Cu7968%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%5D,%22dateAdded%22:2e+15,%22id%22:%2238%22,%22index%22:7,%22parentId%22:%221%22,%22title%22:%22%5Cu79D1%5Cu6280%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%2240%22,%22index%22:0,%22parentId%22:%2239%22,%22title%22:%22%5Cu65B0%5Cu95FB%5Cu8D44%5Cu8BAF%20-%20%5Cu4F73%5Cu53CB%5Cu5728%5Cu7EBF%5Cu6444%5Cu5F71%5Cu7F51%22,%22type%22:%22url%22,%22url%22:%22http://www.photofans.cn/article/index.php%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2239%22,%22index%22:8,%22parentId%22:%221%22,%22title%22:%22%5Cu6444%5Cu5F71%22,%22type%22:%22folder%22%7D,%7B%22children%22:%5B%7B%22dateAdded%22:2e+15,%22id%22:%2242%22,%22index%22:0,%22parentId%22:%2241%22,%22title%22:%22optman%5Cu7684%5Cu535A%5Cu5BA2%20-%20JavaEye%5Cu6280%5Cu672F%5Cu7F51%5Cu7AD9%22,%22type%22:%22url%22,%22url%22:%22http://optman.javaeye.com/%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:3e+15,%22id%22:%2243%22,%22index%22:1,%22parentId%22:%2241%22,%22title%22:%22Bookmarks%20-%20Google%20Chrome%20Extensions%20-%20Google%20Code%22,%22type%22:%22url%22,%22url%22:%22http://code.google.com/chrome/extensions/bookmarks.html%23method-get%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%2241%22,%22index%22:9,%22parentId%22:%221%22,%22title%22:%22chromium%22,%22type%22:%22folder%22%7D,%7B%22dateAdded%22:3e+15,%22id%22:%2244%22,%22index%22:10,%22parentId%22:%221%22,%22title%22:%22%5Cu5AE3%5Cu725B%5Cu535A%5CuFF0D%5Cu6CA1%5Cu6709%5Cu653F%5Cu6CBB%5Cu5185%5Cu5BB9%5Cu7684%5Cu725B%5Cu535A%20(%5Cu6D4B%5Cu8BD5%5Cu7248)%22,%22type%22:%22url%22,%22url%22:%22http://www.bullock.cn/%22,%22visitCount%22:%220%22%7D,%7B%22dateAdded%22:3e+15,%22id%22:%2245%22,%22index%22:11,%22parentId%22:%221%22,%22title%22:%22%5Cu9996%5Cu9875%20-%20%5Cu7EF4%5Cu57FA%5Cu767E%5Cu79D1%5CuFF0C%5Cu81EA%5Cu7531%5Cu7684%5Cu767E%5Cu79D1%5Cu5168%5Cu4E66%22,%22type%22:%22url%22,%22url%22:%22http://zh.wikipedia.org/w/index.php%3Ftitle=%25E9%25A6%2596%25E9%25A1%25B5%26variant=zh-cn%22,%22visitCount%22:%220%22%7D%5D,%22dateAdded%22:2e+15,%22id%22:%221%22,%22index%22:0,%22parentId%22:%220%22,%22title%22:%22%5Cu6536%5Cu85CF%5Cu5939%22,%22type%22:%22folder%22%7D%5D,%22dateAdded%22:2e+15,%22dateGroupModified%22:2e+15,%22id%22:%220%22,%22title%22:%22%22,%22type%22:%22folder%22%7D%5D"]';
		favList.buildList(favData);		
	}
	
	// 判断是否有异常
	try {
		qqbrowser.bookmark.getSyncState(function(result) {
			var syncStateId = eval('(' + result + ')')[0];
			if(syncStateId == 2) { // 异常时
				favList.isSyncError = true;
				favList.isSyncLoading = false;

				favList.showSyncError();
				favList.disableDrag();
			} else if(syncStateId == 1) { // 下载中
               
				favList.isSyncError = false;
				favList.isSyncLoading = true;

				favList.hideSyncError();
				favList.showSyncLoading();				
				favList.disableDrag();
			}
			else {
				favList.isSyncError = false;
				favList.isSyncLoading = false;

				favList.hideSyncError();
				favList.enableDrag();
			}
		});
		
		qqbrowser.bookmark.onSyncStateChanged.addListener(function(syncStateId) {
			if(syncStateId == 2) { // 异常时
				favList.isSyncError = true;	
				favList.isSyncLoading = false;

				favList.showSyncError();
				favList.disableDrag();
			} else if(favList.isRetry && syncStateId == 1) { // 异常时点击重试后下载时
				favList.showSyncLoading();

				favList.isSyncLoading = true;
			} else if(favList.isRetry && syncStateId == 0) { // 异常时点击重试后成功时 
				favList.showSyncSuccess();
				favList.enableDrag();

				favList.isSyncLoading = false;
				favList.isSyncError = false;
				favList.isRetry = false;
			} else if(syncStateId == 1) { // 下载中
				favList.showSyncLoading();
				
				favList.isSyncLoading = true;
				favList.isSyncError = false;

				favList.disableDrag();
				favList.hideSyncError();
			} else {		
				favList.isSyncError = false;
				favList.isSyncLoading = false;
                favList.showSyncSuccess();
				favList.hideSyncError();
				favList.enableDrag();
			}	
		});
	} catch(e) {
	}
	
	// 绑定收藏面板上的所有事件
	this._bindEvents();
};

favList.flush = function(returnData) {
	var returnObject = JSON.parse(returnData);
	errorCode = returnObject[0];
	newItemId = returnObject[1];
	favList.isChange = true;
	
	// 获取新的收藏数据并显示
	qqbrowser.bookmark.getChildren(parseInt(curID), 0, favList.sort);
	favList.openFolder(curID);
	
	// 网络异常时的判断
	if(!favList.checkSyncStatus()) {
		return;
	}
	
	// 不允许重命名根节点
	if(parseInt(curID)==parseInt(rootID)){
		return;
	}
	
	setTimeout(function() {
		favList.editFolderName(newItemId);
	}, 5);
};

favList.checkSyncStatus = function() {
	if(!favList.isLogon || (!favList.isSyncError && !favList.isSyncLoading)) { // 未登录时不判断
		return 1;
	}

	if(favList.isSyncError) {
		favList.showSyncPopupDownloadTip();
	} else if(favList.isSyncLoading) {
		favList.showSyncPopupDownloadEdit();
	}
	
	return 0;
};

/* 显示DownloadTip的同步对话框 */
favList.showSyncPopupDownloadTip = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = qqbrowser.window.currentId();
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadTip", 336, 170, true, escape(''), true);
};

/* 显示DownloadEdit的同步对话框 */
favList.showSyncPopupDownloadEdit = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = qqbrowser.window.currentId();
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadEdit", 336, 170, true, escape(''), true);
};

/* 显示网络异常的提示条  */
/*favList.showSyncError = function() {
	$('#sync-loading').hide();
	$('#sync-success').hide();
	$('#sync-error').show();
}*/

/* 隐藏网络异常的提示条  */
/*favList.hideSyncError = function() {
	$('#sync-error').hide();	
}*/

favList.showSyncLoading = function() {
	var syncError = $('#sync-error');	
	
	if($('#sync-loading').is(':visible')) {
		return;
	}

	if(!$('#sync-error').is(':visible') && !$('#sync-success').is(':visible')) {
		var syncErrorHeight = syncError.outerHeight() + 
			parseInt(syncError.css('margin-bottom').replace('px', ''));

		$('#favListALL').height($('#favListALL').height() - syncErrorHeight);
	}	
	
	$('#sync-error').hide();
	$('#sync-success').hide();
	$('#sync-loading').show();
};

favList.showSyncSuccess = function() {
	if($('#sync-success').is(':visible')) {
		return;
	} 

	$('#sync-loading').hide();
	$('#sync-error').hide();
	$('#sync-success').show();
};

favList.hideSyncSuccess = function() {
	var syncSuccess = $('#sync-success');
	if(syncSuccess.is(':hidden')) {
		return;
	} 

	var syncErrorHeight = syncSuccess.outerHeight() + 
		parseInt(syncSuccess.css('margin-bottom').replace('px', ''));

	$('#favListALL').height($('#favListALL').height() + syncErrorHeight);

	$('#sync-loading').hide();
	$('#sync-error').hide();
	syncSuccess.hide();
};

favList.showSyncError = function() {
	var syncError = $('#sync-error');
	if(syncError.is(':visible')) {
		return;
	} 
	
	if(!$('#sync-loading').is(':visible') && !$('#sync-success').is(':visible')) {
		var syncErrorHeight = syncError.outerHeight() + 
			parseInt(syncError.css('margin-bottom').replace('px', ''));

		$('#favListALL').height($('#favListALL').height() - syncErrorHeight);
	}

	$('#sync-loading').hide();
	$('#sync-success').hide();
	syncError.show();	
};

favList.hideSyncError = function() {
	var syncError = $('#sync-error');
	if(syncError.is(':hidden')) {
		return;
	} 
	
	var syncErrorHeight = syncError.outerHeight() + 
	parseInt(syncError.css('margin-bottom').replace('px', ''));

	$('#favListALL').height($('#favListALL').height() + syncErrorHeight);		
	syncError.hide();	
	$('#sync-loading').hide();
	$('#sync-success').hide();
};

favList.newFolderCallBack=function(returnData){
	
};

favList.editLinkName = function(linkId) {
	var link = $('#' + linkId + ' > div.title > div').get(0),
		title = link.innerText;

	link.outerHTML = '<input type="text" name="' + link.innerHTML + '" value="' + link.innerHTML + '" id="temp" url="' + link.getAttribute('href') + '" />';
	$('#temp').focus().bind('keydown', function() {
		// 回车键，完成重命名
		if(event.keyCode == 13) {
			favList.editLinkNameEnd(this);
		// ESC键，取消重命名
		} else if(event.keyCode == 27) {
			this.outerHTML = '<span>' + title + '</span>';
		}
	}).bind('click', function() {
		event.stopPropagation();
	});
};

favList.editLinkNameEnd = function(input) {
	var id = parseInt($(input).closest('li').attr('id')),
		inputValue = input.value,
		oldTitle = input.name,
		newData = $.trim(inputValue),
		inputTitle = (newData == '') ? oldTitle : newData,
		url = input.getAttribute('url');
	
	favList.isChange = true;
	input.outerHTML = '<a target="_blank" href="' + url + '">' + inputTitle + '</a>';
	try {
		// TODO curID && curItemID?
		qqbrowser.bookmark.update(-1, id, inputTitle, url, function(ret){});
	} catch(e) {}
};

favList.editFolderName = function(folderId) {
	var span = $('#' + folderId + ' > div.title > span').get(0),
		title = span.innerText;
	span.outerHTML = '<input type="text" name="' + span.innerHTML + '" value="' + span.innerHTML + '" id="temp" />';
	$('#temp').focus().bind('keydown', function() {
		// 回车键，完成重命名
		if(event.keyCode == 13) {
			favList.editFolderNameEnd(this);
		// ESC键，取消重命名
		} else if(event.keyCode == 27) {
			this.outerHTML = '<span>' + title + '</span>';
		}
	}).bind('click', function() {
		event.stopPropagation();
	});
};

favList.editFolderNameEnd = function(input) {
	var id = parseInt($(input).closest('li').attr('id'));
	
	var inputValue = input.value;
	var oldTitle = input.name;
	var newData = $.trim(inputValue);	
	var inputTitle = (newData == '') ? oldTitle : newData;
	favList.isChange = true;

	try {
		qqbrowser.bookmark.renameFolder(id, inputTitle, function(returnData) {
			var returnObject = eval('(' + returnData + ')');
			errorCode=returnObject[0];
			if(errorCode == 1) {
				input.outerHTML = '<span>' + inputTitle + '</span>';
			}
			else if(errorCode == -2) {
				input.outerHTML = '<span>' + oldTitle + '</span>';
				alert("同名文件夹已存在，重命名失败");
			}
		});
	} catch(e) {}
};

favList.editEnd = function() {
	var inputElement = $('#favList input[type="text"]').get(0);

	if(inputElement) {		
		if(inputElement.getAttribute('url')) {	
			favList.editLinkNameEnd(inputElement);
		} else {
			favList.editFolderNameEnd(inputElement);
		}
	}	
};

favList.setFavTitle=function(data){
	var userInfo = eval('(' + data + ')')[0];
	if(userInfo.strNickName!=''){
        $("favListHeaderTitle").text(unescape(userInfo.strNickName) + "的收藏");
	}
};
favList.setLogIn=function(){
	qqbrowser.popup.close(qqbrowser.window.currentId()) ;
	qqbrowser.popup.destory(qqbrowser.window.currentId());
	qqbrowser.account.getCurrent(favList.setFavTitle);
};

favList.setLogOut=function(){
	qqbrowser.popup.close(qqbrowser.window.currentId()) ;
	qqbrowser.popup.destory(qqbrowser.window.currentId());
};


favList.sort=function(returnData){
	var returnObject = eval('(' + returnData + ')');
	var unescapedData = unescape(returnObject[0]);
	var favObject = eval('(' + unescapedData + ')');
	var content = favObject;

	var currentFolder=document.getElementById(curID);
	var f=document.getElementById(curID).childNodes;
	// 先删除排序文件夹相应的HTML
	if(f!=null){ // TODO childNodes难道不是永远都不是NULL吗？
		f[1].innerHTML="";
	}
	// 再把内容重新添加到HTML
	favList.addChild(f[1],content);
	//favList.setTabindex();

	favList.setDrag();
	favList.setDrop();
};
favList.check=function(returnData){
	var returnObject = eval('(' + returnData + ')');
	var unescapedData = unescape(returnObject[0]);
	var favObject = eval('(' + unescapedData + ')');
	var currentFolderID = returnObject[1];
	
	if(favObject.length==0){
		var currentFolder=document.getElementById(currentFolderID).childNodes[0];
		currentFolder.className = "title blank";
	}
};

favList.createElementWithClassName=function(type, className) {
	var elm = document.createElement(type);
	elm.className = className;
	return elm;
};

favList.addChild=function(parentNode,content){
	var child;
	for (var i = 0, thisResult; thisResult = content[i]; i++) {
		// 收藏项
		if(thisResult.type=="url"){
			child=favList.createElementWithClassName("li", "fav-item");
			//img
            var headImg = document.createElement("img");
            if (!thisResult.faviconPath)
            {
				headImg.src = "../aero/images/favlist/FavBar_Item.png";
            }
			else
			{
				headImg.src = thisResult.faviconPath;
			}
			headImg.className="favicon";
			headImg.onerror = function() {
				this.src = '../aero/images/favlist/FavBar_Item.png';
			};
			child.appendChild(headImg);
		  
			//title
			var d = document.createElement('div');
			d.className="title";
			// 将以前的<a>标签换为div标签，以解决使用<a>标签拖动时无法滚动的问题
			var link = document.createElement('div');
			var link = document.createElement('div');
			$(link).attr("href",thisResult.url);

			var titleTmp = thisResult.title;
			link.appendChild(document.createTextNode(titleTmp)); 	
			d.appendChild(link);
			child.appendChild(d);
			child.oncontextmenu=function (){ 
					$('#favList .selected').removeClass('selected');
					$('#favList .hover').removeClass('hover');					
					$(this).addClass('selected');
					
					clearTimeout(favList.tooltipTimer);
					
				    event.cancelBubble = true;
					var element = $(event.target);
					element=element.closest('.fav-item');

					curID = element.attr('id');
                    menu.style.posLeft= document.body.scrollLeft+event.x+4;                       
                    menu.style.posTop= document.body.scrollTop+event.y+4;
					if(menu.style.posLeft>$("#fav-list-layer").offset().left+60){
						menu.style.posLeft=$("#fav-list-layer").offset().left+60;
					}
					if(menu.style.posTop>$("#fav-list-layer").offset().top+250){
						menu.style.posTop=menu.style.posTop - 134;
					}
                    menu.style.display="inline"; 
					foldermenu.style.display="none";
                    return false;  
            };

			var deleteImg = document.createElement('img');
			child.id = thisResult.id;
			child.onclick = function (){
				menu.style.display = "none";
				foldermenu.style.display = "none"; 
				
				var url = $('#'+ this.id + '> div.title > div').attr('href');
				browser.extension.builtin.statistics.increase(STATIS_FAV_TOOLBAR_CONTENT);
				qqbrowser.tabs.create(url, 2, 0);
				
				var element = $(event.target);
				element = element.closest('.fav-item');
				qqbrowser.bookmark.popupNavigate(parseInt(element.attr('id')));
				
				// 立即设置焦点
				var windowId = qqbrowser.window.currentId();
				qqbrowser.skin.window.setFocusToWeb(windowId);
				browser.extension.builtin.statistics.increase(STATIS_CMD_FAV_FUNC_FAV_PANEL_ALL_FAV_ITEM_CLICKED);//上报 收藏下拉面板-全部收藏内-item点击访问的次数
				qqbrowser.popup.close(windowId);
				return false;					
			};

			// add drag notifier
			var li = document.createElement('li');
			li.className = 'hr';

			parentNode.appendChild(li);

			parentNode.appendChild(child);
		}
		// 文件夹
		else{
			var child=favList.createElementWithClassName("li", "fav-folder");

			var d = document.createElement('div');
			d.className = "title";
			
			d.onclick = function() {
				try
				{					
					// 拖拽时不展开
					if(isDrag) {
						return; 
					}
					
					$('#favList .selected').removeClass('selected');
					$('#favList .hover').removeClass('hover');					
					$(this).addClass('selected');				
					
					menu.style.display="none";				
					foldermenu.style.display="none"; 	
					event.cancelBubble = true;
					var element = $(event.target);
					element = element.closest('.fav-folder');
					curID = element.attr('id');	
					var div = $(' > div:first-child', element);
					if(div.is('.open')) {
						div.removeClass('open');
					} else {
						div.addClass('open');
					}
					//favList.setTabindex();
					
					try
					{
						qqbrowser.bookmark.getChildren(parseInt(curID), 0, favList.sort);					
					}
					catch (e) {}
					
					$(this).next().toggle();		
				}
				catch (e)
				{
					debug('open' + e.message);
				}
			};
			var titleTmp=thisResult.title;
			d.innerHTML = '<span>' + titleTmp + '</span>';
			child.appendChild(d);
		  
			var cchild = document.createElement('ul');
			cchild.style.display="none";
			child.id=thisResult.id;
			
			// 文件夹，采用递归构造
			if(thisResult.children!=null){
				favList.addChild(cchild,thisResult.children);
			}
			child.appendChild(cchild);

			child.oncontextmenu=function (){
				var title = $(' > div.title', this);
				var offset = title.offset();
				// modified by littleli
				// 解决文件夹底部右键点击时无法出现菜单的bug
				var height = title.height() + 5;
				if(event.pageY > offset.top + height) { // 右键点击不在li范围内，不显示右键菜单
					return false;
				}

				$('#favList .selected').removeClass('selected');
				$('#favList .hover').removeClass('hover');					
				title.addClass('selected');
				
				clearTimeout(favList.tooltipTimer);
				event.cancelBubble = true;
				var element = $(event.target);
				element = element.closest('.fav-folder');
				curID = element.attr('id');
				foldermenu.style.posLeft= document.body.scrollLeft+event.x+4;                       
				foldermenu.style.posTop= document.body.scrollTop+event.y+4; 
				if(foldermenu.style.posLeft>$("#fav-list-layer").offset().left+60){
					foldermenu.style.posLeft=$("#fav-list-layer").offset().left+60;
				}
				if(foldermenu.style.posTop>$("#fav-list-layer").offset().top+235){
					foldermenu.style.posTop=foldermenu.style.posTop-110;
				}
				foldermenu.style.display="inline"; 
				if(parseInt(curID)==parseInt(rootID)){
					
					var ele=document.getElementById("foldermenu");
					var res=ele.getElementsByTagName("li");
					res[1].className="disabled";
					res[2].className="disabled";
				}
				else{
					var ele=document.getElementById("foldermenu");
					var res=ele.getElementsByTagName("li");
					res[1].className="";
					res[2].className="";
				}
				menu.style.display="none";
				updateFolderMenu(parseInt(curID));
            };
			child.onclick=function (){
				menu.style.display="none";
				foldermenu.style.display="none"; 
			};

			// add drag notifier
			var li = document.createElement('li');
			li.className = 'hr';

			parentNode.appendChild(li);

			parentNode.appendChild(child);
			
			if ($(parentNode) == favList.getRoot()) {
				cchild.style.marginLeft = "0px";
			}
			
			try {
				qqbrowser.bookmark.getChildren(parseInt(child.id), 0, favList.check);
			} catch(e) {}
		}
		
		//child.tabIndex = i;
		
		// add by littleli
		// 隐藏根节点的显示
		var tmp=$(".title","#favList")[0];
		tmp = $(tmp);
		tmp.css("display","none");
		
		// 添加文件夹里最后一个hr
		if(i == content.length - 1) {
			var li = document.createElement('li');
			li.className = 'hr';	
			
			parentNode.appendChild(li);			
		}
	}
	
	//favList.setTabindex();
};

favList.isOriginalFav = true;

favList.buildList = function(returnData) {
	try {
		var returnObject = eval('(' + returnData + ')');
		var unescapedData = unescape(returnObject[0]);
		var favObject = eval('(' + unescapedData + ')');

		var content = favObject[0].children;
		rootID = favObject[0].children[0].id;

		var parent = document.getElementById("favList");
		parent.innerHTML = "";
		favList.addChild(parent,content);
		//favList.setTabindex();
		
		// check uin here
		if (favList.isLogon){
			var tmp=$(".title","#favList")[0];
			tmp = $(tmp);
			tmp.css("background-image","url(images/favlist/fav_online_root.png)");
			$("span",tmp).text("网络收藏夹");
		}
		
		favList.isOriginalFav = returnObject[2]; // 判断是不是干净的收藏
		if(!favList.isOriginalFav) {
			favList.openRoot();
		}
		
		document.onclick = function(){
			if(document.activeElement!=menu) 
				menu.style.display="none";
			if(document.activeElement!=foldermenu) 
				foldermenu.style.display="none"; 
			$('#favList .selected').removeClass('selected');
			$('#favList .hover').removeClass('hover');	        
		};
		tblContainer = document.getElementById('favListALL');

		tblContainer.onclick = tblContainer.onscroll = function(){
			if(document.activeElement!=menu) 
				menu.style.display = "none";
			if(document.activeElement != foldermenu) 
				foldermenu.style.display = "none";
		};
		
		// 收藏数据变化监听函数
		qqbrowser.bookmark.onBookmarkChanged.addListener(function(ret){
			// 如果在其它地方修改了收藏数据，则销毁收藏面板
			if (!favList.isChange) {
				qqbrowser.popup.close(qqbrowser.window.currentId()) ;
				qqbrowser.popup.destory(qqbrowser.window.currentId());
			// 
			} else {
				favList.isChange = false;
			}
		}) ;
		
		try
		{
			var windowId = qqbrowser.window.currentId();

			var json = qqbrowser.window.getRect(windowId);
			//var windowRect = eval('(' + json + ')');
			var windowRect = JSON.parse(json);
			var windowHeight = windowRect.bottom - windowRect.top;

			var favListHeight = windowHeight * 0.7 < 550 ? Math.floor(windowHeight * 0.7) : 550; // 最小高度和皮肤窗口70%比较
			
			// 这里的计算有问题
			$('#favListALL').height(favListHeight - ($('body').outerHeight() - $('#favListALL').height())); // 改变内容高度
			qqbrowser.popup.show(qqbrowser.window.currentId(),$('#fav-list-layer').outerWidth(), favListHeight);
		}
		catch (e)
		{
		}

		favList.setDrag();
		favList.setDrop();

		//favList.showTooltip();
	}
	catch (e)
	{
		debug('list' + e.message);
	}
};

/*
favList.setTabindex = function()
{
	var tabindex = 0;
	// 添加tabIndex
	$('li.fav-folder, li.fav-item').each(function(i) {
		if(i === 0) {
			return;
		}
		
		if(!$(this).find('> div:first-child').hasClass('open'))
		{
			this.tabIndex = ++i;
		}
		else
		{
			this.tabIndex = -1;
		}
	});
}
*/

favList.folderOpenTimer = null;


favList.disableDrag = function() {
	var sortElements = $("#favList > li li.fav-folder, #favList > li li.fav-item");

	sortElements.draggable({ disabled: true });
};

favList.enableDrag = function() {
	var sortElements = $("#favList > li li.fav-folder, #favList > li li.fav-item");

	sortElements.draggable({ disabled: false });
};

favList.setDrag = function() {
	var sortElements = $("#favList > li li.fav-folder, #favList > li li.fav-item");
	//sortElements.each(function())
	
	sortElements.draggable({
//		axis: 'y',
		opacity: 0.7,
		zIndex: 20,
		helper: 'clone',
		distance: 8,
//		revert: true,
		containment: "#fav-list-layer",
		scroll: true,
		cancel: ".fav-list-footer",
		start: function(event, ui) {
			favList.isChange = true;
			isDrag = 1;
			var dropElement = $(this); // drop element
		},
		drag: function(event, ui) {
		},
		stop: function() {
			isDrag = 0;	
			clearTimeout(favList.folderOpenTimer);
			clearInterval(favList.scrollTimer);
		}
	});
};

favList.scrollTimer = null;
favList.dropElementId = null; // 因为over和drop时，dropElement不一致，以over的为准

favList.setDrop = function() {
	var sortElements = $("#favList li.fav-folder, #favList li.fav-item");

	sortElements.droppable({
		// 放下时
		drop: function(event, ui) {
			try
			{
				if($('li.fav-item.hover').length > 0) {
					return;
				}
				var dragElement = ui.draggable[0]; // drag element

				isDrag = 0;		
				clearTimeout(favList.folderOpenTimer);
				clearInterval(favList.scrollTimer);

				var dragLi = $(dragElement).closest('li');
				var dragHrLi = dragLi.next();

				var dropLi = $('li.hr.enabled');
				if(dropLi.length == 1) { // 放在placeholder上
					var dropLiParent = dropLi.parents('li');		
					var dropParentId = dropLiParent.attr('id');		
					
					if(dropLi.is('#favList > li:last-child')) {
						$('li.hr.enabled').removeClass('enabled');
						return;
					}
														
					// 为通知浏览器构造数据
					var dropIndex = $(' > ul > li', dropLiParent).index(dropLi) / 2;
					var dragId = dragLi.attr('id');

					// 通知浏览器
					try {
						// index从0开始， -1表示最后一位
						qqbrowser.bookmark.move(parseInt(dragId), parseInt(dropParentId), parseInt(dropIndex), function(result) {
							var moveCode = eval('(' + result + ')')[0];

							// TODO 冲突的情况应该弹出对话框，确认
							if(moveCode == 1) {
								$(dragLi).insertAfter(dropLi); // 放在文件夹最后一个
								$(dragHrLi).insertAfter(dragLi);

								document.onmousemove = null;
								$('li.hr.enabled').removeClass('enabled');
							}
						});
					} catch(e) {}	
				
				} else { // 放在文件夹上
					var dropParentId = favList.dropElementId;	
					// 为通知浏览器构造数据
					var dropIndex = -1;
					var dragId = dragLi.attr('id');
					
					if(!dropParentId || dropParentId == 'favList') {
						return;
					}

					// 通知浏览器
					try {
						// index从0开始， -1表示最后一位
						qqbrowser.bookmark.move(parseInt(dragId), parseInt(dropParentId), parseInt(dropIndex), function(result) {
							var moveCode = eval('(' + result + ')')[0];

							// TODO 冲突的情况应该弹出对话框，确认
							if(moveCode == 1) {
								dropLi = $('#' + favList.dropElementId);

								var dragLiParent = $(dragLi.parents('li')).get(0);

								if(dropLi.is('.fav-folder')) {
									$(' > ul', dropLi).append(dragLi); // 放在文件夹最后一个
									$(' > ul', dropLi).append(dragHrLi);
								}

								if($(' > ul > li:not(.hr, .ui-draggable-dragging)', dragLiParent).length == 0) { // 处理之前父文件夹，如果为空，设置相应属性
									$(' > ul', dragLiParent).remove();
									$(' > div:first-child', dragLiParent).removeClass('open').addClass('blank');
								}
								
								$(' > div.title', dropLi).removeClass('blank'); // 处理现在的父文件夹

								$('.hover').removeClass('hover');

								document.onmousemove = null;
								$('li.hr.enabled').removeClass('enabled');	
							}

						});
					} catch(e) {}									
				}		
		
			}
			catch (e)
			{
				debug('drop' + e.message);
			}
			//favList.setTabindex();
		},
		// 放在一个收藏上时
		over: function(e, ui) {
			try
			{
				
				$('div.hover, li.hover').removeClass('hover');	
				var dragElement = ui.draggable; // drag element

				var dropElement = $(this); // drop element		
				dropElement = dropElement.closest('li');
				
				favList.dropElementId = dropElement.attr('id');			
				
				$('li.hr.enabled').removeClass('enabled');

				document.onmousemove = function() {
					if(event.pageY - dropElement.offset().top < 10 && event.pageY - dropElement.offset().top > 3) { // 范围有点大，限制在10像素内
						$('li.hr.enabled').removeClass('enabled');
						
						// 为over的li添加hover效果
						if(dropElement.is('.fav-folder')) {
							$(' > div', dropElement).addClass('hover');
						} else {
							dropElement.addClass('hover');
						}
					}
					else if(event.pageY - dropElement.offset().top <= 3) { // 范围有点大，限制在10像素内	
						$('li.hr.enabled').removeClass('enabled');
						// 为over的li去掉hover效果
						if(dropElement.is('.fav-folder')) {
							$(' > div', dropElement).removeClass('hover');
						} else {
							dropElement.removeClass('hover');
						}
						$(dropElement).prev().addClass('enabled');
					}
				};
				
				// 如果是folder，且展开，显示的hr在下面第一个位置
				if(dropElement.is('.fav-folder') && $('> div:first-child', dropElement).is('.open') && dropElement.attr('id') != dragElement.parents('li').attr('id')) {
					$('> ul > li:first-child.hr', dropElement).addClass('enabled');
				}


				// 否则在后面显示分割条
				else {
					if(dropElement.is('#favList > li:first-child + li')) {
						return;
					}
					
					dropElement.next().addClass('enabled');

					// 如果是folder，且未展开，延迟展开
					if(dropElement.is('.fav-folder')) {
						clearTimeout(favList.folderOpenTimer);
					}
				}
			}
			catch (e)
			{
				debug('over' + e.message);
			}
		},
		// 移出区域
		out: function() {
			$('div.hover, li.hover').removeClass('hover');				
			$('li.hr.enabled').removeClass('enabled');
			// 解决hover时打开文件夹的事件控制
			var dropElement = $(this);
			dropElement.attr("couldOpen", 0);
		}
	});
};
favList.getRoot = function() {
	return $('#favList > li:first-child + li');
};


// 打开根目录
favList.openRoot = function() {
	var div = $('#favList > li:first-child + li > div');
	div.addClass('open');
	div.next().toggle(); // show tree
	//favList.setTabindex();
};

// 打开相应文件夹
favList.openFolder = function(id) {
	var div = $('#' + id + ' > div');
	div.addClass('open');
	div.next().show(); // show tree

	$('#' + id).next().removeClass('enabled');
	//favList.setTabindex();
};

favList.currentElement = null;

$(function() {
	favList.init();
});

function debug(text) {
//	$('#favListSearchInput').val(text);
}

String.prototype.replaceAll = function(AFindText, ARepText){ 
	// TODO AFindText为元字符的情况
	try
	{	
		return this.replace(new RegExp(AFindText, "gm"), ARepText);  
	}
	catch (e)
	{
	}	
};
function updateFolderMenu(curID){
	qqbrowser.bookmark.getChildren(curID,1,function(returnData){
		var returnObject = eval('(' + returnData + ')');
		var unescapedData = unescape(returnObject[0]);
		var favObject = eval('(' + unescapedData + ')');
		var content = favObject;
		if (0 == content.length){
			$('#openLinks').addClass('disabled');
			$('#sort').addClass("disabled");
		} else {
			$('#openLinks').removeClass('disabled');
			$('#sort').removeClass("disabled");
		}		
	});
}